function [sys,E]=OscHarm(L,Ep0,m,varargin)
% Etats confins d'un oscillateur harmonique
%   >> L    = largeur (nm) du puits
%   >> Ep0  = Profondeur (eV) du puits (Ep0 < 0)
%   >> m    = Masse (par rapport  l'lectron) de l'objet physique
%   >> E    = Valeur de l'nergie de l'objet physique
%
% Olivier Pujol : septembre 2013

%% Arguments d'entre optionnels

switch length(varargin)
    case 0
        nx=100;                     % Valeur par dfaut du nombre de points selon Ox
        nE=500;                     % Valeur par dfaut du nombre de valeurs de l'nergie
    case 1
        nx=varargin{1};             % Valeur par dfaut du nombre de points selon Ox
        nE=500;                     % Valeur par dfaut du nombre de valeurs de l'nergie
    case 2
        nx=varargin{1};             % Valeur par dfaut du nombre de points selon Ox
        nE=varargin{2};             % Valeur par dfaut du nombre de valeurs de l'nergie
    case 4
        nx=varargin{1};             
        nE=varargin{2};             
        E=linspace(varargin{3},varargin{4},nE);     % Ensemble des valeurs de l'nergie
    otherwise
        ('Mauvais nombre d''arguments d''entre optionnels');
end

%% Energie potentielle

% Construction
x=linspace(-L/2,L/2,nx);           % Domaine spatial
Epc=4*Ep0*(x/L).^2;          % Energie potentielle (parabole) avec origine au fond du puits

% Discrtisation
[M,xt,Ep]=discretisation(x,Epc);    % Dicrtisation

% Valeurs de l'nergie
if (length(varargin)~=4)
    E=linspace(min(Ep),Ep0,nE);   % Ensemble des valeurs de l'nergie
end    

if (max(E)>Ep0)
    disp(' ');
    disp('Certaines valeurs de E sont hors du domaine des tats confins');
    disp(' ');
    return;
end

%% Etats confins

[sys,E]=Epot(M,xt,Ep,m,E);          % Fabrication du systme
sysconf(sys,E);                     % Etats confins

return;